unit txtedit1;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, Menus, ExtCtrls, StdCtrls, Clipbrd, Printers,
  memoex32;

type
  TTextEdit = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    New1: TMenuItem;
    Open1: TMenuItem;
    Saveas1: TMenuItem;
    Print1: TMenuItem;
    Printersetup1: TMenuItem;
    Leftjustify1: TMenuItem;
    Center1: TMenuItem;
    Exit1: TMenuItem;
    Edit1: TMenuItem;
    Selectall1: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    Paste1: TMenuItem;
    Delete1: TMenuItem;
    Options1: TMenuItem;
    Fonts1: TMenuItem;
    Undo1: TMenuItem;
    ASCII1: TMenuItem;
    OEM1: TMenuItem;
    Wordwrap1: TMenuItem;
    Search1: TMenuItem;
    Find1: TMenuItem;
    Replace1: TMenuItem;
    Next1: TMenuItem;
    Start1: TMenuItem;
    End1: TMenuItem;
    Forward1: TMenuItem;
    Backward1: TMenuItem;
    Save1: TMenuItem;
    Date1: TMenuItem;
    Time1: TMenuItem;
    N7: TMenuItem;
    N6: TMenuItem;
    N5: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N2: TMenuItem;
    N1: TMenuItem;

    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    SpeedBar: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton13: TSpeedButton;
    SpeedButton14: TSpeedButton;
    SpeedButton15: TSpeedButton;
    Memo1: TMemo;
    MemoFindDlg1: TMemoFindDlg;
    MemoReplaceDlg1: TMemoReplaceDlg;
    MemoPrintDlg1: TMemoPrintDlg;
    MemoNav1: TMemoNav;
    procedure New1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Printersetup1Click(Sender: TObject);
    procedure Undo1Click(Sender: TObject);
    procedure Cut1Click(Sender: TObject);
    procedure Copy1Click(Sender: TObject);
    procedure Paste1Click(Sender: TObject);
    procedure Delete1Click(Sender: TObject);
    procedure Selectall1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Fonts1Click(Sender: TObject);
    procedure Print1Click(Sender: TObject);
    procedure Center1Click(Sender: TObject);
    procedure Wordwrap1Click(Sender: TObject);
    procedure ASCII1Click(Sender: TObject);
    procedure MemoFindDlg1Find(Sender: TObject);
    procedure MemoReplaceDlg1Find(Sender: TObject);
    procedure Find1Click(Sender: TObject);
    procedure Replace1Click(Sender: TObject);
    procedure Next1Click(Sender: TObject);
    procedure Start1Click(Sender: TObject);
    procedure End1Click(Sender: TObject);
    procedure Forward1Click(Sender: TObject);
    procedure Backward1Click(Sender: TObject);
    procedure MemoReplaceDlg1Replace(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Date1Click(Sender: TObject);
    procedure Time1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private-Deklarationen }
    CurrentName: String;
    LastDlg: Integer;
    function Messages(Msg: String; MsgType: Integer): Integer;
    function CanFree: Boolean;
  public
    { Public-Deklarationen }
    function LoadMemo(FName, Title: String): Boolean;
  end;

var
  TextEdit: TTextEdit;

implementation

{$R *.DFM}

    {General}

procedure TTextEdit.FormCreate(Sender: TObject);
begin
  if ParamCount > 0 then LoadMemo(ParamStr(1), ExtractFileName(ParamStr(1)));
end;

function TTextEdit.Messages(Msg: String; MsgType: Integer): Integer;
var
  Buttons: Integer;
begin
  Screen.Cursor:= crDefault;
  Buttons:= 0;
  case MsgType of
    0: Buttons:= MB_ICONINFORMATION + MB_OK;
    1: Buttons:= MB_ICONQUESTION + MB_YESNO;
    2: Buttons:= MB_ICONQUESTION + MB_YESNOCANCEL;
  end;
  Result:= Application.MessageBox(PChar(Msg), PChar(Application.Title), Buttons);
end;

function TTextEdit.LoadMemo(FName, Title: String): Boolean;
begin
  Result:= True;
  try
    if FName <> '' then Memo1.Lines.LoadFromFile(FName);
    Caption:= Title;
    CurrentName:= FName;
    Memo1.Modified:= False;
  except
    Result:= False;
  end;
end;

function TTextEdit.CanFree: Boolean;
var
  I: Integer;
begin
  Result:= True;
  if Memo1.Lines.Count > 0 then
  begin
    if Memo1.Modified then
    begin
      I:= Messages('Save current text ?', 2);
      case I of
           IDYES      : Saveas1Click(Nil);
           IDNO       : Memo1.Modified:= False;
           IDCANCEL   : Result:= False;
      end;
    end;
  end;
end;

procedure TTextEdit.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose:= canFree;
end;

    {MenuItem: File}

procedure TTextEdit.New1Click(Sender: TObject);
begin
  if CanFree then
  begin
    Memo1.Clear;
    LoadMemo('', Application.Title);
  end;
end;

procedure TTextEdit.Open1Click(Sender: TObject);
begin
  if CanFree then
  if OpenDialog1.Execute then LoadMemo(OpenDialog1.FileName, ExtractFileName(OpenDialog1.FileName));
end;

procedure TTextEdit.Saveas1Click(Sender: TObject);
begin
  if Memo1.Lines.Count > 0 then
  begin
    SaveDialog1.FileName:= CurrentName;
    if ((Sender = Save1) and (CurrentName <> '')) or SaveDialog1.Execute then
    begin
      Memo1.Lines.SaveToFile(SaveDialog1.FileName);
      Memo1.Modified:= False;
    end;
  end;
end;

procedure TTextEdit.Fonts1Click(Sender: TObject);
begin
  try
    with TFontDialog.Create(Self) do
    begin
      Font.Assign(Memo1.Font);
      if Execute then Memo1.Font.Assign(Font);
      Free;
    end;
  finally;
  end;
end;

procedure TTextEdit.Print1Click(Sender: TObject);
begin
  MemoPrintDlg1.Headline:= CurrentName;
  MemoPrintDlg1.Execute;
  ActiveControl:= Memo1;
end;

procedure TTextEdit.Printersetup1Click(Sender: TObject);
begin
  try
    with TPrinterSetupDialog.Create(Self) do
    begin
      Execute;
      Free;
    end;
  finally;
  end;
end;

procedure TTextEdit.Exit1Click(Sender: TObject);
begin
  Close;
end;

    {MenuItem: Edit}

procedure TTextEdit.Undo1Click(Sender: TObject);
begin
  Memo1.Perform(EM_UNDO, 0, 0);
end;

procedure TTextEdit.Selectall1Click(Sender: TObject);
begin
  Memo1.SelectAll
end;

procedure TTextEdit.Cut1Click(Sender: TObject);
begin
  Memo1.CutToClipboard;
end;

procedure TTextEdit.Copy1Click(Sender: TObject);
begin
  Memo1.CopyToClipboard;
end;

procedure TTextEdit.Paste1Click(Sender: TObject);
begin
  if Clipboard.HasFormat(CF_TEXT) then Memo1.PasteFromClipboard;
end;

procedure TTextEdit.Delete1Click(Sender: TObject);
begin
  Memo1.ClearSelection;
end;

procedure TTextEdit.Date1Click(Sender: TObject);
begin
  Memo1.SelText:= DateToStr(Date);
end;

procedure TTextEdit.Time1Click(Sender: TObject);
begin
  Memo1.SelText:= TimeToStr(Time);
end;

    {MenuItem: Search}

    {Search: Events}

procedure TTextEdit.MemoFindDlg1Find(Sender: TObject);
begin
  if not MemoFindDlg1.FindResult then Messages('Search string not found !', 0);
  LastDlg:= 1;
end;

procedure TTextEdit.MemoReplaceDlg1Find(Sender: TObject);
begin
  if not MemoReplaceDlg1.FindResult then Messages('Search string not found !', 0);
  LastDlg:= 2;
end;

procedure TTextEdit.MemoReplaceDlg1Replace(Sender: TObject);
begin
  MemoReplaceDlg1.Find;
  LastDlg:= 3;
end;

    {Search: Methods}

procedure TTextEdit.Find1Click(Sender: TObject);
begin
  MemoFindDlg1.Execute;
end;

procedure TTextEdit.Replace1Click(Sender: TObject);
begin
  MemoReplaceDlg1.Execute;
end;

procedure TTextEdit.Next1Click(Sender: TObject);
begin
  case LastDlg of
    1: MemoFindDlg1.Find;
    2: MemoReplaceDlg1.Find;
    3: MemoReplaceDlg1.Replace;
  end;
end;

procedure TTextEdit.Start1Click(Sender: TObject);
begin
  MemoNav1.Position:= navStart;
end;

procedure TTextEdit.End1Click(Sender: TObject);
begin
  MemoNav1.Position:= navEnd;
end;

procedure TTextEdit.Forward1Click(Sender: TObject);
begin
  MemoNav1.Position:= navNext;
end;

procedure TTextEdit.Backward1Click(Sender: TObject);
begin
  MemoNav1.Position:= navPrevious;
end;

    {MenuItem: Options}

procedure TTextEdit.Center1Click(Sender: TObject);
begin
  if Sender = Center1 then
  begin
    Center1.Checked:= not Center1.Checked;
    Leftjustify1.Checked:= not Center1.Checked;
  end
  else
  begin
    Leftjustify1.Checked:= not Leftjustify1.Checked;
    Center1.Checked:= not Center1.Checked;
  end;
  if Center1.Checked then Memo1.Alignment:= taCenter
  else Memo1.Alignment:= taLeftJustify;
end;

procedure TTextEdit.ASCII1Click(Sender: TObject);
begin
  if Sender = OEM1 then
  begin
    OEM1.Checked:= not OEM1.Checked;
    ASCII1.Checked:= not OEM1.Checked;
  end
  else
  begin
    ASCII1.Checked:= not ASCII1.Checked;
    OEM1.Checked:= not ASCII1.Checked;
  end;
  Memo1.OEMConvert:= ASCII1.Checked;
end;

procedure TTextEdit.Wordwrap1Click(Sender: TObject);
begin
  Wordwrap1.Checked:= not Wordwrap1.Checked;
  with Memo1 do
  begin
    if Wordwrap1.Checked then
    begin
      ScrollBars:= ssVertical;
      WordWrap:= True;
    end
    else
    begin
      ScrollBars:= ssBoth;
      WordWrap:= False;
    end;
  end;
end;

end.
